/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.ISectorDevice;
import org.apache.log4j.Logger;

public class MappingSectorDevice
implements ISectorDevice {
    protected static Logger log = Emulator.log;
    protected static final int freeSectorNumber = -1;
    protected ISectorDevice sectorDevice;
    protected int[] sectorMapping;
    protected File mappingFile;
    protected boolean sectorMappingDirty;

    public MappingSectorDevice(ISectorDevice sectorDevice, File mappingFile) {
        this.sectorDevice = sectorDevice;
        this.mappingFile = mappingFile;
        this.sectorMapping = new int[0];
        this.sectorMappingDirty = true;
        try {
            this.readMappingFile();
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"Mapping file not found, creating it", (Throwable)e);
        }
        catch (IOException e) {
            log.warn((Object)"Error reading mapping file", (Throwable)e);
        }
    }

    public void setNumSectors(int numSectors) throws IOException {
        int previousNumSectors = this.getNumSectors();
        if (numSectors != previousNumSectors) {
            this.sectorMapping = Arrays.copyOf(this.sectorMapping, numSectors);
            if (numSectors > previousNumSectors) {
                Arrays.fill(this.sectorMapping, previousNumSectors, this.sectorMapping.length, -1);
            }
            this.sectorMappingDirty = true;
        }
    }

    protected void readMappingFile() throws IOException {
        FileInputStream mappingFileReader = new FileInputStream(this.mappingFile);
        int mappingSize = (int)(this.mappingFile.length() / 4L);
        this.sectorMapping = new int[mappingSize];
        byte[] buffer = new byte[4];
        IntBuffer intBuffer = ByteBuffer.wrap(buffer).asIntBuffer();
        for (int i = 0; i < mappingSize; ++i) {
            ((InputStream)mappingFileReader).read(buffer);
            this.sectorMapping[i] = intBuffer.get(0);
        }
        ((InputStream)mappingFileReader).close();
        this.sectorMappingDirty = false;
    }

    protected void writeMappingFile() throws IOException {
        FileOutputStream mappingFileWriter = new FileOutputStream(this.mappingFile);
        byte[] buffer = new byte[4];
        IntBuffer intBuffer = ByteBuffer.wrap(buffer).asIntBuffer();
        int numSectors = this.getNumSectors();
        for (int i = 0; i < numSectors; ++i) {
            intBuffer.put(0, this.sectorMapping[i]);
            ((OutputStream)mappingFileWriter).write(buffer);
        }
        ((OutputStream)mappingFileWriter).close();
        this.sectorMappingDirty = false;
    }

    protected int mapSector(int sectorNumber) throws IOException {
        if (sectorNumber >= 0 && sectorNumber < this.getNumSectors()) {
            return this.sectorMapping[sectorNumber];
        }
        return -1;
    }

    protected int getFreeSectorNumber() throws IOException {
        int numSectors = this.getNumSectors();
        for (int i = 0; i < numSectors; ++i) {
            if (this.sectorMapping[i] != -1) continue;
            return i;
        }
        return -1;
    }

    protected void setSectorMapping(int sectorNumber, int mappedSectorNumber) {
        this.sectorMapping[sectorNumber] = mappedSectorNumber;
        this.sectorMappingDirty = true;
    }

    @Override
    public void readSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        int mappedSectorNumber = this.mapSector(sectorNumber);
        if (mappedSectorNumber >= 0) {
            this.sectorDevice.readSector(mappedSectorNumber, buffer, offset);
        } else {
            Arrays.fill(buffer, offset, offset + 2048, (byte)0);
        }
    }

    @Override
    public int readSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        for (int i = 0; i < numberSectors; ++i) {
            this.readSector(sectorNumber + i, buffer, offset + i * 2048);
        }
        return numberSectors;
    }

    @Override
    public int getNumSectors() throws IOException {
        return this.sectorMapping.length;
    }

    @Override
    public void close() throws IOException {
        if (this.sectorMappingDirty) {
            this.writeMappingFile();
        }
        this.sectorDevice.close();
    }

    @Override
    public void writeSector(int sectorNumber, byte[] buffer, int offset) throws IOException {
        int freeSectorNumber = this.getFreeSectorNumber();
        if (freeSectorNumber < 0) {
            throw new IOException(String.format("Sector Device '%s' is full", this.mappingFile));
        }
        this.sectorDevice.writeSector(freeSectorNumber, buffer, offset);
        this.setSectorMapping(freeSectorNumber, sectorNumber);
    }

    @Override
    public void writeSectors(int sectorNumber, int numberSectors, byte[] buffer, int offset) throws IOException {
        for (int i = 0; i < numberSectors; ++i) {
            this.writeSector(sectorNumber + i, buffer, offset + i * 2048);
        }
    }
}

